PROGRAM test
!
!  Purpose:
!    To test subroutine test_get_arguments.  This program
!    examines its command line arguments using subroutine
!    test get arguments.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    03/02/96    S. J. Chapman        Original code
!
USE interfaces
IMPLICIT NONE

! List of parameters:
INTEGER, PARAMETER :: num_string = 4  ! No of strings to hold args

! List of local variables:
INTEGER :: i                       ! Loop index
INTEGER :: num_args                ! Number of arguments returned
CHARACTER(len=30),DIMENSION(num_string) :: string
                                   ! Array to hold arguments
INTEGER :: error                   ! Error flag: 0=no error
                                   !   -1=sys library error
                                   !   +num=too many arguments
! Get the arugments.
CALL get_arguments( num_args, string, num_string, error )

! Display results.
WRITE (*,'(1X,A,I2,A)') 'There are ', num_args, ' arguments.'
DO i = 1, num_args
   WRITE (*,'(1X,A,I2,A,A)') 'Argument ', i, ' is: ', string(i)
END DO
WRITE (*,'(1X,A,I2,A)') 'Error status = ', error

END PROGRAM

 
