PROGRAM test_lsq_fit_2
!
!  Purpose:
!    To test subroutine lsq_fit_2, which performs a least-
!    squares fit to a parabola.  The input data for this fit
!    comes from a user-specified input data file.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    02/13/96    S. J. Chapman        Original code
!
IMPLICIT NONE

! List of parameters:
INTEGER, PARAMETER :: lu = 12          ! Unit for file i/o
INTEGER, PARAMETER :: max_vals = 1000  ! Maximum data pts

! List of variables:
REAL, DIMENSION(0:2) :: c        ! Coefficients of fit
INTEGER :: error                 ! Error flag
LOGICAL :: exceed = .FALSE.      ! Logical indicating that array 
                                 ! limits are exceeded.
CHARACTER(len=20) :: filename    ! Input data file name
INTEGER :: istat                 ! Status: 0 for success
INTEGER :: nvals = 0             ! Number of values read
REAL :: t1, t2                   ! Temporary vars for read
REAL, DIMENSION(max_vals) :: x   ! x values of (x,y) pairs
REAL, DIMENSION(max_vals) :: y   ! y values of (x,y) pairs

! Prompt user and get the name of the input file.
WRITE (*,1000)
1000 FORMAT (1X,'This program performs a least-squares fit of an ',/, &
             1X,'input data set to a parabola.  Enter the name',/, &
             1X,'of the file containing the input (x,y) pairs: ')
READ (*,'(A)') filename

! Open the input file
OPEN (UNIT=lu, FILE=filename, STATUS='OLD', ACTION='READ', &
      IOSTAT=istat )

! Was the OPEN successful? 
fileopen: IF ( istat == 0 ) THEN         ! Open successful
 
   ! The file was opened successfully, so read the data,
   input: DO
      READ (lu,*,IOSTAT=istat) t1, t2   ! Get values
      IF ( istat /= 0 ) EXIT            ! Exit on end of data 
      nvals = nvals + 1                 ! Bump count
      size: IF ( nvals <= max_vals ) THEN ! Too many values?
         x(nvals) = t1                  ! No: Save values
         y(nvals) = t2                  ! No: Save values
      ELSE
         exceed = .TRUE.                   ! Yes: Array overflow
      END IF size
   END DO input

   ! Was the array size exceeded?  If so, tell user and quit.
   toobig: IF ( exceed ) THEN
      WRITE (*,1010) nvals, max_vals
      1010 FORMAT (' Max array size exceeded: ', I6, ' > ', I6 )
   ELSE

      ! Limit not exceeded: fit data to parabola.
      CALL lsq_fit_2 ( x, y, nvals, c, error )
 
      ! Tell user about results of fit.
      fit_error: IF ( error == 0 ) THEN
          WRITE (*, 1020 ) c, nvals
          1020 FORMAT ('0','Regression coefficients for the ', &
                       'least- squares fit parabola:', &
                     /,1X,'  c(0)  = ', F12.3, &
                     /,1X,'  c(1)  = ', F12.3, &
                     /,1X,'  c(2)  = ', F12.3, &
                     /,1X,'  nvals = ', I12 )
      ELSE
         WRITE (*,"(' Error from lsq_fit_2: ', I6 )") error
      END IF fit_error
   END IF toobig
 
ELSE fileopen

   ! Else file open failed.  Tell user.
   WRITE (*,1030) istat
   1030 FORMAT (1X,'File open failed--status = ', I6)

END IF fileopen
END PROGRAM
