PROGRAM test_root
!
!  Purpose:
!    To test subroutine root, which locates the roots of 
!    function "fun" that fall between x=x1 and x=x2.  
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    02/16/96    S. J. Chapman        Original code
!
IMPLICIT NONE

! Declare the external function passed to subroutine root.
REAL, EXTERNAL :: fun

! Declare parameter:
REAL, PARAMETER :: epsilon = 1.0E-5  ! Convergence criterion

! List of variables:
REAL :: aroot             ! Root
REAL :: dx = 0.1          ! Step size
INTEGER :: error          ! Error flag
REAL :: x1 = -6.          ! Starting point to search for root.
REAL :: x2 = 6.           ! Ending point to search for root.

! Tell user what we are doing.
WRITE (*,100) x1, x2
100 FORMAT ('0','Searching for roots between ',F14.5,' and ',F14.5,'.')

! Begin WHILE loop.
DO
   IF ( x1 > x2 ) EXIT

   ! Call subroutine root with each step size. 
   CALL root ( fun, x1, x2, dx, aroot, error )
 
   !  Write out results.
   IF ( error == 0 ) THEN
      WRITE (*,1010) aroot
      1010 FORMAT (' ','There is a root at ',F14.5, '.')
      x1 = aroot + epsilon * MAX(1.,ABS(aroot))  ! Avoid prob at aroot = 0.
   ELSE IF ( error == 2 ) THEN
      WRITE (*,1020) x1, x2
      1020 FORMAT (' ','No root found between ',F14.5,' and ',F14.5,'.')
      x1 = x2 + epsilon
   END IF
END DO
END PROGRAM
