/* AboutDialog.java
 *
 * Created on 14 June 2000, 22:00
 */
 
import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.net.URL;
import java.io.IOException;

/** 
 *
 * @author  aak97
 * @version 
 */
public class AboutDialog extends javax.swing.JDialog 
{

  private boolean buttonPressed = false;
  private int     theButtonPressed = -1;
  private JEditorPane theEditorPane;

  private Frame parent;
  
  /** Creates new form AboutDialog */
  public AboutDialog(java.awt.Frame theParent,boolean modal) 
  {
    super (theParent, modal);
    parent = theParent;
    initComponents ();
    pack ();
    centre();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    jPanel2 = new javax.swing.JPanel ();
    okayButton = new javax.swing.JButton ();
    jPanel1 = new javax.swing.JPanel ();
    jScrollPane1 = new javax.swing.JScrollPane ();
    theEditorPane = createEditorPane ("About.html");
//    aboutDnaText = new javax.swing.JTextArea ();
//    aboutDnaText.setEditable(false);
    setTitle ("About");
    setResizable (false);
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );


  
      okayButton.setText ("Okay");
      okayButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          okayButtonPerformed (evt);
        }
      }
      );
  
      jPanel2.add (okayButton);
  

    getContentPane ().add (jPanel2, java.awt.BorderLayout.SOUTH);

    jPanel1.setBorder (new javax.swing.border.TitledBorder(""));

      jScrollPane1.setPreferredSize (new java.awt.Dimension(350, 250));
  
        jScrollPane1.setViewportView (theEditorPane);
    
      jPanel1.add (jScrollPane1);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.NORTH);

  }//GEN-END:initComponents

  private void okayButtonPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayButtonPerformed
// Add your handling code here:
    theButtonPressed = 1;
    buttonPressed = true;
    setVisible(false);
  }//GEN-LAST:event_okayButtonPerformed



  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  
  public int showAboutDialog()
  { 
      centre();
      setVisible(true);
      return theButtonPressed;
  }
	private void displayURL(URL url, JEditorPane editorPane) 
	{
        	try 
		{
            		editorPane.setPage(url);
        	} 
		catch (IOException e) 
		{
            		System.err.println("Attempted to read a bad URL: " + url);
        	}
    	}

  private JEditorPane createEditorPane(String theFileName)
  {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        String dummyString = null;
        try 
	{
            dummyString = "file:"
                + System.getProperty("user.dir")
                + System.getProperty("file.separator")
                + "doc"
                + System.getProperty("file.separator")
                + theFileName;
            URL aboutURL = new URL(dummyString);
            this.displayURL(aboutURL, editorPane);
        } 
	catch (Exception e) 
	{
            System.err.println("Couldn't create about URL: " + dummyString);
        }

        return editorPane;
   }



  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new AboutDialog (new javax.swing.JFrame (), true).show ();
  }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel jPanel2;
  private javax.swing.JButton okayButton;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JScrollPane jScrollPane1;
//  private javax.swing.JTextArea aboutDnaText;
  // End of variables declaration//GEN-END:variables

	void centre() 
	{
          	pack();

          	Point p = parent.getLocation();
          	Dimension d = parent.getSize();
          	Dimension s = getSize();

          	p.translate((d.width - s.width) / 2,
                      (d.height - s.height) / 2);
          	setLocation(p);
      	}
}
