<!--
  Electronic book/Digital library support for Voyager.

  Author: Harry.Plantinga@wheaton.edu
-->

 <!--================ ebooks ================================-->

 <!-- Block-level additions -->
 <!ELEMENT attr %Inline;>          <!-- attribution, signature, etc. -->
 <!ATTLIST attr %attrs; >

 <!ELEMENT argument %Inline;>      <!-- chapter subhead or topic -->
 <!ATTLIST argument %attrs; >

 <!ELEMENT l %Inline;>             <!-- line of poetry -->
 <!ATTLIST l %attrs;>

 <!ELEMENT glossary (term|def+)+>  <!-- list of definitions -->
 <!ATTLIST glossary %attrs;
    type     CDATA  #IMPLIED>

 <!ELEMENT sync EMPTY>             <!-- synchronization point -->
 <!ATTLIST sync %attrs;
    type     CDATA  #REQUIRED
    value    CDATA  #REQUIRED>

 <!ELEMENT verse (l|%misc;)*>      <!-- group of poetic lines -->
 <!ATTLIST verse %attrs;
    type     CDATA  "stanza"
    n        CDATA  #IMPLIED>

 <!--=====================================================================-->
 <!-- Inline additions -->
 <!ELEMENT date %Inline;>          <!-- any reference to a date -->
 <!ATTLIST date %attrs;   
    value    %Datetime;  #IMPLIED>

 <!ELEMENT index EMPTY>            <!-- index entry -->
 <!ATTLIST index %attrs;
    type     CDATA  "subject"  
    subject1 CDATA  #REQUIRED
    subject2 CDATA  #IMPLIED
    subject3 CDATA  #IMPLIED
    subject4 CDATA  #IMPLIED
    target   IDREF  #IMPLIED>     
    
 <!ELEMENT insertIndex EMPTY>      <!-- add a computed index here -->
 <!ATTLIST insertIndex %attrs;
    level    CDATA  #IMPLIED
    type     CDATA  #REQUIRED>

 <!ELEMENT foreign %Inline;>       <!-- foreign-language phrase -->
 <!ATTLIST foreign 
    lang   %LanguageCode; #REQUIRED
    dir    (rtl|ltr)      #IMPLIED
    %coreattrs;
    %events;>

 <!ELEMENT name %Inline;>          <!-- a person's name -->
 <!ATTLIST name %attrs; >

 <!ELEMENT unclear %Flow;>         <!-- text that may be incorrect -->
 <!ATTLIST unclear %attrs; >


 <!--=====================================================================-->
 <!-- Controls (inline or block level)  (for misc) -->
 <!ELEMENT added (#PCDATA | %block; | %inline; | %misc; | div1 | div2 |
           div3 | div4 | div5 | div6)*>  <!-- text added to the source doc -->
 <!ATTLIST added %attrs;
    resp     CDATA      #IMPLIED
    reason   CDATA      #IMPLIED
    date     %Datetime; #IMPLIED>

 <!ELEMENT deleted (#PCDATA | %block; | %inline; | %misc; | div1 | div2 |
           div3 | div4 | div5 | div6)*>  <!-- text deleted from source doc -->
 <!ATTLIST deleted %attrs;
    resp     CDATA      #IMPLIED
    reason   CDATA      #IMPLIED
    date     %Datetime; #IMPLIED>

 <!ELEMENT note %Flow;>            <!-- footnote, endnote, etc. -->
 <!ATTLIST note %attrs;
    place    (foot|end|inline|margin|interlinear) "foot"
    resp     CDATA      #IMPLIED
    target   IDREF      #IMPLIED
    targetEnd IDREF     #IMPLIED
    anchored (yes|no)   "yes">

 <!ELEMENT pb EMPTY>               <!-- page break in print edition -->
 <!ATTLIST pb %attrs;
    n        CDATA  #IMPLIED
    href     %URI;  #IMPLIED>


 <!--=====================================================================-->
 <!-- Other additions (not in Block or Inline models) -->
 <!ELEMENT term %Inline;>          <!-- term of definition list -->
 <!ATTLIST term %attrs;>

 <!ELEMENT def %Flow;>             <!-- definitions -->
 <!ATTLIST def %attrs;>

 <!--=====================================================================-->
 <!-- Structure (divs) -->
 <!ELEMENT div1 ((%block; | %misc;)*, div2*)> <!-- top divisions -->
 <!ATTLIST div1 %attrs;
    type     CDATA  #IMPLIED
    n        CDATA  #IMPLIED>

 <!ELEMENT div2 ((%block; | %misc;)*, div3*)> 
 <!ATTLIST div2 %attrs;
    type     CDATA  #IMPLIED
    n        CDATA  #IMPLIED>

 <!ELEMENT div3 ((%block; | %misc;)*, div4*)> 
 <!ATTLIST div3 %attrs;
    type     CDATA  #IMPLIED
    n        CDATA  #IMPLIED>

 <!ELEMENT div4 ((%block; | %misc;)*, div5*)> 
 <!ATTLIST div4 %attrs;
    type     CDATA  #IMPLIED
    n        CDATA  #IMPLIED>

 <!ELEMENT div5 ((%block; | %misc;)*, div6*)> 
 <!ATTLIST div5 %attrs;
    type     CDATA  #IMPLIED
    n        CDATA  #IMPLIED>

 <!ELEMENT div6 (%block; | %misc;)*> 
 <!ATTLIST div6 %attrs;
    type     CDATA  #IMPLIED
    n        CDATA  #IMPLIED>


 <!--=====================================================================-->
 <!-- head elements -->

 <!-- generalInfo: info about the book, for all editions -->
 <!ELEMENT generalInfo (description?, firstPublished?, pubHistory?, 
    comments?)>
 <!ELEMENT description %Flow;>     <!-- paragraph-length desc of document -->
 <!ELEMENT firstPublished %Flow;>  <!-- date first published -->
 <!ELEMENT pubHistory %Flow;>      <!-- any info about publication history -->
 <!ELEMENT comments %Flow;>        <!-- any other general comments -->

 <!-- printSourceInfo: info about the print source for this ebook -->
 <!ELEMENT printSourceInfo (published, copyLocation*, image*)>
 <!ATTLIST image 
    type     CDATA  #REQUIRED
    href     %URI;  #REQUIRED>
 <!ELEMENT published %Flow;>       <!-- full bibliographic reference -->
 <!ELEMENT copyLocation %Flow;>    <!-- location of print source -->
 <!ELEMENT image EMPTY>            <!-- any on-line images of print source -->

 <!-- electronicEdInfo: info about this electronic text -->
 <!ELEMENT electronicEdInfo (publisherID, authorID, bookID, version, 
    editorialComments?, revisionHistory?, status?, DC, comments?)>
 <!ELEMENT publisherID (#PCDATA)>  <!-- publisher code -->
 <!ELEMENT authorID (#PCDATA)>     <!-- author code assigned by publisher -->
 <!ELEMENT bookID (#PCDATA)>       <!-- book code assigned by publisher -->
 <!ELEMENT version (#PCDATA)>      <!-- version code -->
 <!ELEMENT editorialComments %Flow;> <!-- editorial practices -->
 <!ELEMENT revisionHistory %Flow;> <!-- revision history of this etext -->
 <!ELEMENT status %Flow;>          <!-- how clean/complete is this etext? -->

 <!--=====================================================================-->
 <!-- Dublin Core record -->
 <!ELEMENT DC (DC.Title | DC.Creator | DC.Subject | DC.Description |
    DC.Publisher | DC.Contributor | DC.Date | DC.Type | DC.Format |
    DC.Identifier | DC.Source | DC.Language | DC.Relation | 
    DC.Coverage | DC.Rights)*>

 <!-- attributes for DC elements: sub (subtype), scheme, lang -->
 <!ENTITY % DCAtts 
   "sub    CDATA #IMPLIED
    scheme CDATA #IMPLIED
    lang   CDATA #IMPLIED" >

 <!ELEMENT DC.Title       (#PCDATA)> <!ATTLIST DC.Title       %DCAtts;>
 <!ELEMENT DC.Creator     (#PCDATA)> <!ATTLIST DC.Creator     %DCAtts;>
 <!ELEMENT DC.Subject     (#PCDATA)> <!ATTLIST DC.Subject     %DCAtts;>
 <!ELEMENT DC.Description (#PCDATA)> <!ATTLIST DC.Description %DCAtts;>
 <!ELEMENT DC.Publisher   (#PCDATA)> <!ATTLIST DC.Publisher   %DCAtts;>
 <!ELEMENT DC.Contributor (#PCDATA)> <!ATTLIST DC.Contributor %DCAtts;>
 <!ELEMENT DC.Date        (#PCDATA)> <!ATTLIST DC.Date        %DCAtts;>
 <!ELEMENT DC.Type        (#PCDATA)> <!ATTLIST DC.Type        %DCAtts;>
 <!ELEMENT DC.Format      (#PCDATA)> <!ATTLIST DC.Format      %DCAtts;>
 <!ELEMENT DC.Identifier  (#PCDATA)> <!ATTLIST DC.Identifier  %DCAtts;>
 <!ELEMENT DC.Source      (#PCDATA)> <!ATTLIST DC.Source      %DCAtts;>
 <!ELEMENT DC.Language    (#PCDATA)> <!ATTLIST DC.Language    %DCAtts;>
 <!ELEMENT DC.Relation    (#PCDATA)> <!ATTLIST DC.Relation    %DCAtts;>
 <!ELEMENT DC.Coverage    (#PCDATA)> <!ATTLIST DC.Coverage    %DCAtts;>
 <!ELEMENT DC.Rights      (#PCDATA)> <!ATTLIST DC.Rights      %DCAtts;>


 <!-- entities -->


 <!ENTITY % inline.ebook "| date | foreign | name | note | sync | unclear">
 <!ENTITY % block.ebook  "| glossary | argument | verse | attr | insertIndex">
 <!ENTITY % misc.ebook   "| added | deleted | index | pb">

